-------------------------------------------------------------------------------------------------------------------
-- REVISION 6 LUA Scripts (Ov3rHell3XoduZ)
-- Special Features for METRO QUAD
-------------------------------------------------------------------------------------------------------------------
function regexEncode(var) return (var:gsub('%%', '%%%'):gsub('%^', '%%^'):gsub('%$', '%%$'):gsub('%(', '%%('):gsub('%)', '%%)'):gsub('%.', '%%.'):gsub('%[', '%%['):gsub('%]', '%%]'):gsub('%*', '%%*'):gsub('%+', '%%+'):gsub('%-', '%%-'):gsub('%?', '%%?')) end
function CommonNormal() return LoadFont("Common Normal") end
function SquareFont() return LoadFont("SquareFont") end
function Miso() return LoadFont("_miso 30px") end
function MisoBold() return LoadFont("_miso Bold 30px") end
function show(element) return element:visible(true) end -- show
function hide(element) return element:visible(false) end -- hide
function MouseInputAllowed() local file = LoadFile("MouseInput.cfg","Settings") if file == "Enabled" then return true else return false end end
function ThemeVersion() return "VERSION: 5.0.7 / REVISION: 9.6.0" end
function HeaderCommand() return cmd(x,CenterX();y,Top()+18;diffuse,Black();settext,ScreenHeaderText();maxwidth,260) end

function IsPlayerEnabled(pn) return GAMESTATE:IsPlayerEnabled(pn) end
function IsHumanPlayer(pn) return GAMESTATE:IsHumanPlayer(pn) end
function GetCurrentCourse() return GAMESTATE:GetCurrentCourse() end
function GetCurrentSong() return GAMESTATE:GetCurrentSong() end
function GetCurrentSteps(pn) return GAMESTATE:GetCurrentSteps(pn) end
function GetCurrentTrail(pn) return GAMESTATE:GetCurrentTrail(pn) end
function GetCurrentStyle() return GAMESTATE:GetCurrentStyle() end
function IsDemonstration() return GAMESTATE:IsDemonstration() end

function CenterX() return SCREEN_CENTER_X end
function CenterY() return SCREEN_CENTER_Y end
function Left() return SCREEN_LEFT end
function Right() return SCREEN_RIGHT end
function Top() return SCREEN_TOP end
function Bottom() return SCREEN_BOTTOM end
function Width() return SCREEN_WIDTH end
function Height() return SCREEN_HEIGHT end

function Black() return Color("Black") end
function White() return Color("White") end
function Red() return Color("Red") end
function Blue() return Color("Blue") end
function Green() return Color("Green") end
function Yellow() return Color("Yellow") end
function Orange() return Color("Orange") end
function Purple() return Color("Purple") end

ColorP1 = GameColor.PlayerColors.PLAYER_1
ColorP2 = GameColor.PlayerColors.PLAYER_2

-------------------------------------------------------------------------------------------------------------------
-- Function used to add Easter Eggs easy and fast.
-------------------------------------------------------------------------------------------------------------------
function EasterEgg(number, text)
	number = number or 1
	text = text or ""
	
	return Def.ActorFrame{InitCommand=cmd(draworder,999);
		Def.Quad{
			InitCommand=cmd(xy,Left()+8,Top()+8;setsize,200,48;align,0,0;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2));
		};
		Def.Quad{
			InitCommand=cmd(xy,Left()+12,Top()+12;setsize,192,40;align,0,0;diffuse,color(LoadFile("ThemeColor.cfg","Settings")));
		};
		LoadActor(THEME:GetPathB("","_easteregg"))..{
			InitCommand=cmd(xy,Left()+22,Top()+14;zoom,0.35;align,0,0);
		};
		CommonNormal()..{Text="EASTER EGG #"..number.." FOUND!";
			InitCommand=cmd(xy,Left()+56,Top()+16;align,0,0;zoom,0.4;maxwidth,352;shadowlength,1);
		};
		MisoBold()..{Text=text;
			InitCommand=cmd(xy,Left()+56,Top()+28;align,0,0;zoom,0.35;wrapwidthpixels,400;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3);shadowlength,1);
		};
	};
end

-------------------------------------------------------------------------------------------------------------------
-- Now each screen Header will be loaded automatically from the table tHeaders.
-------------------------------------------------------------------------------------------------------------------
function ScreenHeaderText()
	local screen = SCREENMAN:GetTopScreen():GetName()
	local header
	
	for k in pairs(tHeaders) do
		if screen == k then
			header = tHeaders[screen]
		end
	end
	return tostring(header)
end

-------------------------------------------------------------------------------------------------------------------
--
-------------------------------------------------------------------------------------------------------------------
function FailQuadColor(pn)
	local c
	if STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats(pn):GetFailed() then
		c = Black()
	else
		c = BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)
	end
	return c
end

-------------------------------------------------------------------------------------------------------------------
-- This will return depending of Song or Course if value is Steps or Trail.
-------------------------------------------------------------------------------------------------------------------
function GetCurrentStepsOrTrail(pn)
	if GAMESTATE:IsCourseMode() then return GAMESTATE:GetCurrentTrail(pn) else return GetCurrentSteps(pn) end
end

-------------------------------------------------------------------------------------------------------------------
-- Commify Function (Thanks Kyzentun).
-------------------------------------------------------------------------------------------------------------------
function commify(n, sep)
	n= tostring(n)
	local subs= {}
	local sub_count= math.ceil(#n / 3)
	local curr_sub= sub_count
	
	for i= #n, 0, -3 do
		local start= math.max(1, i-2)
		subs[curr_sub]= n:sub(start, i)
		curr_sub= curr_sub - 1
	end
	return table.concat(subs, sep)
end

-------------------------------------------------------------------------------------------------------------------
-- This will return a renamed Difficulty, (Difficulty_Beginner --> Novice).
-------------------------------------------------------------------------------------------------------------------
function GetDifficulty(pn)
	local IsStepsOrTrail
	if GetCurrentSteps(pn) == nil then return nil else IsStepsOrTrail = GetCurrentStepsOrTrail(pn) end

	local Steps = IsStepsOrTrail
	local Diff = Steps:GetDifficulty()
	local difficulty
	
	for k in pairs(tDifficulties) do
		if Diff == k then
			difficulty = tDifficulties[Diff]
		end
	end
	return difficulty
end

-------------------------------------------------------------------------------------------------------------------
-- This will return a raw name Difficulty.
-------------------------------------------------------------------------------------------------------------------
function GetRawDifficulty(pn)
	local IsStepsOrTrail
	if GetCurrentSteps(pn) == nil then return "Difficulty_Edit" else IsStepsOrTrail = GetCurrentStepsOrTrail(pn) end

	local GetSteps = IsStepsOrTrail
	local Diff = GetSteps:GetDifficulty()
	return Diff
end

-------------------------------------------------------------------------------------------------------------------
-- This will return the Description from the current Step.
-------------------------------------------------------------------------------------------------------------------
function GetDescription(pn)
	local IsStepsOrTrail
	if GetCurrentSteps(pn) == nil then return "" else IsStepsOrTrail = GetCurrentStepsOrTrail(pn) end

	local GetSteps = IsStepsOrTrail
	local ChartName = GetSteps:GetDescription()
	
	if ChartName == "" then ChartName = "Untitled" end
	return ChartName
end

-------------------------------------------------------------------------------------------------------------------
-- This will return the Meter from the current Step.
-------------------------------------------------------------------------------------------------------------------
function GetMeter(pn)
	local IsStepsOrTrail
	if GetCurrentSteps(pn) == nil then return 1 else IsStepsOrTrail = GetCurrentStepsOrTrail(pn) end

	local GetSteps = IsStepsOrTrail
	local Meter = GetSteps:GetMeter()
	return Meter
end

-------------------------------------------------------------------------------------------------------------------
-- This will returns the Leading value for the played TapNoteScores. [ScreenViewScores]
-------------------------------------------------------------------------------------------------------------------
function LeadingToPlayedFourZeros(pn,i,tns)
	local value
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local plSS = pSS:GetPlayerStageStats(pn)
	local TNS = plSS:GetTapNoteScores(tns)
	
	if TNS < 10 then value = 3 elseif TNS < 100 then value = 2 elseif TNS < 1000 then value = 1 elseif TNS > 1001 then value = 0 end
	return value
end

-------------------------------------------------------------------------------------------------------------------
-- It will return a value depending of the digits of the Judgment.
-------------------------------------------------------------------------------------------------------------------
function LeadingToFourZeros(pn,tns)
	local i
	local StageStats = STATSMAN:GetCurStageStats()
	local PlayerStats = StageStats:GetPlayerStageStats(pn)
	local Judgment = PlayerStats:GetTapNoteScores(tns)
	
	if Judgment < 10 then i = 3 elseif Judgment < 100 then i = 2 elseif Judgment < 1000 then i = 1 elseif Judgment > 1001 then i = 0 end
	return i
end

-------------------------------------------------------------------------------------------------------------------
-- It will return a value depending of the digits of the Current Max Combo
-------------------------------------------------------------------------------------------------------------------
function LeadingToFiveZerosForMaxCombo(pn)
	local i
	local StageStats = STATSMAN:GetCurStageStats()
	local PlayerStats = StageStats:GetPlayerStageStats(pn)
	local MaxCombo = PlayerStats:MaxCombo()
	
	if MaxCombo < 10 then i = 4 elseif MaxCombo < 100 then i = 3 elseif MaxCombo < 1000 then i = 2 elseif MaxCombo < 10000 then i = 1 elseif MaxCombo > 10001 then i = 0 end
	return i
end

-------------------------------------------------------------------------------------------------------------------
-- It will return the (Leading) value depending of the digits of the HighScore.
-------------------------------------------------------------------------------------------------------------------
function LeadingToFourZerosForSavedTNS(pn,i,tns)
	local Song, Steps
	local l = 3
	
	if GetCurrentSong() == nil then return l else Song = GetCurrentSong() end
	if GetCurrentSteps(pn) == nil then return nil else Steps = GetCurrentSteps(pn) end
	
	local Profile = PROFILEMAN:GetProfile(pn):GetHighScoreList(Song,Steps)
	local HighScores = Profile:GetHighScores()
	local Score = HighScores[i]
	
	if Score == nil then Score = 0 else Score = HighScores[i]:GetTapNoteScore(tns) end
	if Score < 10 then l = 3 elseif Score < 100 then l = 2 elseif Score < 1000 then l = 1 elseif Score > 1001 then l = 0 end
	return l
end

-------------------------------------------------------------------------------------------------------------------
-- It will return a value depending of the digits of the Accumulated Judgments [ScreenEvaluation].
-------------------------------------------------------------------------------------------------------------------
function LeadingToSixZerosForAccumStats(pn,tns)
	local i
	local StageStats = STATSMAN:GetAccumPlayedStageStats()
	local PlayerStats = StageStats:GetPlayerStageStats(pn)
	local Judgment = PlayerStats:GetTapNoteScores(tns)
	
	if Judgment < 10 then i = 5 elseif Judgment < 100 then i = 4 elseif Judgment < 1000 then i = 3 elseif Judgment < 10000 then i = 2 elseif Judgment < 100000 then i = 1 elseif Judgment < 100001 then i = 0 end
	return i
end

-------------------------------------------------------------------------------------------------------------------
-- It will return a value depending of the digits of the Current Holds Judgment [ScreenEvaluation].
-------------------------------------------------------------------------------------------------------------------
function LeadingToSixZerosForHNS(pn,hns)
	local i
	local StageStats = STATSMAN:GetCurStageStats()
	local PlayerStats = StageStats:GetPlayerStageStats(pn)
	local Judgment = PlayerStats:GetHoldNoteScores(hns)

	if Judgment < 10 then i = 11 elseif Judgment < 100 then i = 9 elseif Judgment < 1000 then i = 7 elseif Judgment < 10000 then i = 5 elseif Judgment < 100000 then i = 3 end
	return i
end

-------------------------------------------------------------------------------------------------------------------
-- It will return a value depending of the digits of the Current Max Combo for [ScreenEvaluation].
-------------------------------------------------------------------------------------------------------------------
function LeadingToFiveZerosForMaxCombo(pn)
	local i
	local StageStats = STATSMAN:GetCurStageStats()
	local PlayerStats = StageStats:GetPlayerStageStats(pn)
	local MaxCombo = PlayerStats:MaxCombo()
	
	if MaxCombo < 10 then i = 4 elseif MaxCombo < 100 then i = 3 elseif MaxCombo < 1000 then i = 2 elseif MaxCombo < 10000 then i = 1 elseif MaxCombo > 10001 then i = 0 end
	return i
end

-------------------------------------------------------------------------------------------------------------------
-- It will return a value depending of the digits of the Radar Value.
-------------------------------------------------------------------------------------------------------------------
function LeadingToFiveZerosForRadarValue(pn,rc)
	local l
	local RadarValue = GetCurrentSteps(pn):GetRadarValues(pn):GetValue(rc)

	if RadarValue < 10 then l = 4 elseif RadarValue < 100 then l = 3 elseif RadarValue < 1000 then l = 2 elseif RadarValue < 10000 then l = 1 elseif RadarValue < 10001 then l = 0 end	
	return l
end

-------------------------------------------------------------------------------------------------------------------
-- It will return a value depending of the digits of the Radar Value.
-------------------------------------------------------------------------------------------------------------------
function LeadingToSavedRadarValue(pn,i,rc)
	local l
	if GetCurrentSong() == nil then return 7 else Song = GetCurrentSong() end
	if GetCurrentSteps(pn) == nil then return nil else Steps = GetCurrentSteps(pn) end
	
	local Profile = PROFILEMAN:GetProfile(pn):GetHighScoreList(Song,Steps)
	local HighScores = Profile:GetHighScores()
	local Score = HighScores[i]
	
	if Score == nil then Score = 7 else Score = HighScores[i]:GetRadarValues():GetValue(rc) end
	if Score < 10000 then l = 7 elseif Score < 100000 then l = 8 elseif Score < 1000000 then l = 9 end
	return l
end

-------------------------------------------------------------------------------------------------------------------
-- It will return a value depending of the digits of the Radar Value.
-------------------------------------------------------------------------------------------------------------------
function PositionForRadarValue(pn,rc)
	local l
	if GetCurrentSteps(pn) == nil then return 4 else Steps = GetCurrentSteps(pn) end
	local RadarValue = Steps:GetRadarValues(pn):GetValue(rc)

	if RadarValue < 10000 then l = 4 elseif RadarValue < 100000 then l = 5 elseif RadarValue < 1000000 then l = 6 end	
	return l
end

-------------------------------------------------------------------------------------------------------------------
-- This will return a Saved TapNoteScore (tns) depending from Song and StepOrTrail from HighScore (i).
-------------------------------------------------------------------------------------------------------------------
function GetSavedTNS(pn,i,tns)
	local Profile = PROFILEMAN:GetProfile(pn):GetHighScoreList(GetCurrentSong(),GetCurrentStepsOrTrail(pn))
	local HighScores = Profile:GetHighScores()
	local Score = HighScores[i]
	
	if Score == nil then Score = 0 else Score = HighScores[i]:GetTapNoteScore(tns) end
	return Score
end

-------------------------------------------------------------------------------------------------------------------
-- This will return a Saved TapNoteScore (tns) but return nil if there's not song from HighScore (i).
-------------------------------------------------------------------------------------------------------------------
function GetFixedSavedTNS(pn,i,tns)
	local Song, Steps
	
	if GetCurrentSong() == nil then return nil else Song = GetCurrentSong() end
	if GetCurrentSteps(pn) == nil then return nil else Steps = GetCurrentSteps(pn) end
	
	local Profile = PROFILEMAN:GetProfile(pn):GetHighScoreList(Song,Steps)
	local HighScores = Profile:GetHighScores()
	local Score = HighScores[i]
	
	if Score == nil then Score = 0 else Score = HighScores[i]:GetTapNoteScore(tns) end
	return Score
end

-------------------------------------------------------------------------------------------------------------------
-- This will return the current RadarValue (RadarCategory rc).
-------------------------------------------------------------------------------------------------------------------
function GetRadarValue(pn,rc)
	local Steps
	if GetCurrentSong() == nil then return nil else Song = GetCurrentSong() end
	if GetCurrentSteps(pn) == nil then return nil else Steps = GetCurrentSteps(pn) end
	return Steps:GetRadarValues(pn):GetValue(rc)
end

-------------------------------------------------------------------------------------------------------------------
-- This will return a Saved RadarValue (RadarCategory rc) but return nil if there's not song from HighScore (i).
-------------------------------------------------------------------------------------------------------------------
function GetFixedSavedRadarValue(pn,i,rc)
	local Song, Steps
	
	if GetCurrentSong() == nil then return nil else Song = GetCurrentSong() end
	if GetCurrentSteps(pn) == nil then return nil else Steps = GetCurrentSteps(pn) end
	
	local Profile = PROFILEMAN:GetProfile(pn):GetHighScoreList(Song,Steps)
	local HighScores = Profile:GetHighScores()
	local Score = HighScores[i]
	
	if Score == nil then Score = 0 else Score = HighScores[i]:GetRadarValues():GetValue(rc) end
	return Score
end

-------------------------------------------------------------------------------------------------------------------
-- This will return a Saved Score of a different player (pn) and from a determinate HighScore (i).
-------------------------------------------------------------------------------------------------------------------
function GetSavedScore(pn,i)
	local Song, StepsOrTrail
	
	if GetCurrentSong() == nil then return nil else Song = GetCurrentSong() end
	if GetCurrentSteps(pn) == nil then return nil else StepsOrTrail = GetCurrentStepsOrTrail(pn) end
	
	local Profile = PROFILEMAN:GetProfile(pn):GetHighScoreList(Song,StepsOrTrail)
	local HighScores = Profile:GetHighScores()
	local Score = HighScores[i]
	
	if Score == nil then Score = 0 else Score = HighScores[i]:GetPercentDP() end
	return FormatPercentScore(Score):gsub("%%","")
end

-------------------------------------------------------------------------------------------------------------------
-- This will return a Saved Grade (as a string) for a different player from a determinate HighScore.
-------------------------------------------------------------------------------------------------------------------
function GetSavedStringGrade(pn,i)
	local Profile = PROFILEMAN:GetProfile(pn):GetHighScoreList(GetCurrentSong(),GetCurrentStepsOrTrail(pn))
	local HighScores = Profile:GetHighScores()
	local TopScore = HighScores[i]
	local Grade, value
	
	if TopScore then
		Grade = TopScore:GetGrade()
	end
	
	for new, raw in ipairs(tGrades.rawGrades) do
		if Grade == raw then
			value = tGrades.newGrades[new]
		end
		if value == nil then
			value = "n/a"
		end
	end
	return tostring(value)
end

-------------------------------------------------------------------------------------------------------------------
-- This will return a Saved Meter And Difficulty for a different player. [ScreenViewScores]
-------------------------------------------------------------------------------------------------------------------
function GetPlayedDifficulty(pn,i)
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local plSS = pSS:GetPlayerStageStats(pn)
	local pSteps = plSS:GetPlayedSteps()
	local Step = pSteps[1]
	
	if Step == nil then return nil else Step = pSteps[1] end
	
	local Meter = Step:GetMeter()
	local Diff = Step:GetDifficulty()
	local Renamed_Difficulties
	
	for k in pairs(tDifficulties) do
		if Diff == k then
			Renamed_Difficulties = tDifficulties[Diff]
		end
	end
	return Renamed_Difficulties .. " " .. Meter
end

-------------------------------------------------------------------------------------------------------------------
-- This will return a Saved Meter for a different player. [ScreenViewScores]
-------------------------------------------------------------------------------------------------------------------
function GetPlayedMeter(pn,i)
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local plSS = pSS:GetPlayerStageStats(pn)
	local pSteps = plSS:GetPlayedSteps()
	local Step = pSteps[1]
	
	if Step == nil then return nil else Step = pSteps[1] end
	
	local Meter = Step:GetMeter()
	return Meter
end

-------------------------------------------------------------------------------------------------------------------
-- This will return a Saved Grade of a different player (pn) and from a determinate HighScore (i).
-------------------------------------------------------------------------------------------------------------------
function GetPlayedScore(pn,i)
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local plSS = pSS:GetPlayerStageStats(pn)
	local Score = plSS:GetPercentDancePoints()
	return Score
end

-------------------------------------------------------------------------------------------------------------------
-- This will return a Saved Grade of a different player (pn) and from a determinate HighScore (i).
-------------------------------------------------------------------------------------------------------------------
function GetPlayedGrade(pn,i)
	local value
	local pSS = STATSMAN:GetPlayedStageStats(i)
	local plSS = pSS:GetPlayerStageStats(pn)
	local Grade = plSS:GetGrade()
	
	if Grade == nil then Grade = "N/A" else Grade = plSS:GetGrade() end
	
	for new, raw in ipairs(tGrades.rawGrades) do
		if Grade == raw then
			value = tGrades.newGrades[new]
		end
		if value == nil then
			value = "n/a"
		end
	end
	return tostring(value)
end

-------------------------------------------------------------------------------------------------------------------
-- This will return the obtained grade as texture. [ScreenEvaluation]
-------------------------------------------------------------------------------------------------------------------
function GetObtainedTextureGrade(pn)
	local CurrentStats = STATSMAN:GetCurStageStats()
	local StageStats = CurrentStats:GetPlayerStageStats(pn);
	local GetGrade = StageStats:GetGrade()
	local value
	
	for i = 1,17 do
		if GetGrade == "Grade_Tier"..string.format("%02.f",i) then
			value = THEME:GetPathG("GradeDisplayEval","Tier"..string.format("%02.f",i))
		end
		if GetGrade == "Grade_Failed" then
			value = THEME:GetPathG("GradeDisplayEval","Failed")
		end
	end
	return value
end

-------------------------------------------------------------------------------------------------------------------
-- This will return the current Grade for each player. [ScreenGameplay]
-------------------------------------------------------------------------------------------------------------------
function GetCurrentStringGrade(pn)
	local CurGrade = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn):GetGrade()
	local value
	
	for new, raw in ipairs(tGrades.rawGrades) do
		if CurGrade == raw then
			value = tGrades.newGrades[new]
		end
	end
	return tostring(value)
end

-------------------------------------------------------------------------------------------------------------------
-- This will return the next possible Grade for each player.
-------------------------------------------------------------------------------------------------------------------
function NextStringGrade(pn)
	local value
	local sGrade = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn)
	local cGrade = sGrade:GetGrade()
	
	for new, raw in ipairs(tGrades.rawGrades) do
		if cGrade == raw then
			value = tGrades.newGrades[new-1]
		end
		if value == nil then
			value = "n/a"
		end
	end
	return tostring(value)
end

-------------------------------------------------------------------------------------------------------------------
-- SURROUNDLIFE: This will return a different boolean value for each Player.
-------------------------------------------------------------------------------------------------------------------
function LifeVisible(pn)
	local value = ""
	local option = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.LifeVisible
	
	if option == "Enable" then
		value = true
	else
		value = false
	end
	return value
end

-------------------------------------------------------------------------------------------------------------------
-- PLAYERSTATS: This will return a different boolean value for each Player.
-------------------------------------------------------------------------------------------------------------------
function IsStatsVisible(pn)
	local IsVisible = ""
	local option = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.PlayerStats
	
	if option == "On" then
		IsVisible = true
	else
		IsVisible = false
	end
	return IsVisible
end

-------------------------------------------------------------------------------------------------------------------
-- SUBTRACTIVESCORING:
-------------------------------------------------------------------------------------------------------------------
function IsSubtractiveScoringVisible(pn)
	local IsVisible = ""
	local option = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.SubtractiveScoring
	
	if option == "On" then
		IsVisible = true
	else
		IsVisible = false
	end
	return IsVisible
end

-------------------------------------------------------------------------------------------------------------------
-- MEASURECOUNTER:
-------------------------------------------------------------------------------------------------------------------
function IsMeasureCounterVisible(pn)
	local IsVisible = ""
	local option = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.MeasureCounter
	
	if option ~= "None" then
		IsVisible = true
	else
		IsVisible = false
	end
	return IsVisible
end

-------------------------------------------------------------------------------------------------------------------
-- AUTORESTARTWITHBUTTON: This will return a different boolean value for both players.
-------------------------------------------------------------------------------------------------------------------
function IsAutoRestartEnabled()
	local IsEnabled
	local option = MetroQuad.Global.MiscOptions.AutoRestartWithButton
	
	if option == "On" then
		IsEnabled = true
	else
		IsEnabled = false
	end
	return IsEnabled
end

-------------------------------------------------------------------------------------------------------------------
-- PLAYERFIELD: This will return a determinate position depending of the current gametype or style.
-------------------------------------------------------------------------------------------------------------------
function PlayFieldPosition(pn)
	local Style = GAMESTATE:GetCurrentStyle():GetName()
	local Gametype = GAMESTATE:GetCurrentGame():GetName()
	local Pos

	if pn == PLAYER_1 then
		if Gametype == "dance" then
			if Style == "solo" then
				Pos = Left()
			elseif Style == "single" then
				Pos = CenterX()-228
			elseif Style == "versus" then
				Pos = CenterX()-216
			else
				Pos = CenterX()
			end
		end
		if Gametype == "pump" then
			if Style == "single" or Style == "versus" then
				Pos = CenterX()-228
			else
				Pos = CenterX()
			end
		end
		if Gametype == "techno" then
			Pos = CenterX()
		end
	end
	
	if pn == PLAYER_2 then
		if Gametype == "dance" then
			if Style == "solo" then
				Pos = Right()
			elseif Style == "single" then 
				Pos = CenterX()+228
			elseif Style == "versus" then 
				Pos = CenterX()+216
			else
				Pos = CenterX()
			end
		end
		if Gametype == "pump" then
			if Style == "single" then
				Pos = CenterX()+228
			elseif Style == "versus" then
				Pos = math.floor(scale((2.15/3),0,1,SCREEN_LEFT,SCREEN_RIGHT))
			else
				Pos = CenterX()
			end
		end
		if Gametype == "techno" then
			Pos = CenterX()
		end
	end
	return Pos
end

-------------------------------------------------------------------------------------------------------------------
-- PLAYERFIELD: This will return a determinate position depending of Player Number.
-------------------------------------------------------------------------------------------------------------------
function PlayFieldPositionForElements(pn)
	local Style = GAMESTATE:GetCurrentStyle():GetName()
	local Gametype = GAMESTATE:GetCurrentGame():GetName()
	local Pos
	if pn == PLAYER_1 then
		if Gametype == "dance"then
			if Style == "solo" then
				Pos = CenterX()
			elseif Style == "single" then
				Pos = CenterX()-228
			elseif Style == "versus" then
				Pos = CenterX()-216
			else
				Pos = CenterX()
			end
		end
		if Gametype == "pump" then
			if Style == "single" or Style == "versus" then
				Pos = CenterX()-216
			else
				Pos = CenterX()
			end
		end
		if Gametype == "techno" then
			Pos = CenterX()
		end
	end
	if pn == PLAYER_2 then
		if Gametype == "dance" then
			if Style == "solo" then
				Pos = CenterX()
			elseif Style == "single" then
				Pos = CenterX()+228
			elseif Style == "versus" then
				Pos = CenterX()+216
			else
				Pos = CenterX()
			end
		end
		if Gametype == "pump" then
			if Style == "single" or Style == "versus" then
				Pos = CenterX()+228
			else
				Pos = CenterX()
			end
		end
		if Gametype == "techno" then
			Pos = CenterX()
		end
	end
	return Pos
end

-------------------------------------------------------------------------------------------------------------------
-- PLAYERFIELD: This will return the position for the FlashedColumns.
-------------------------------------------------------------------------------------------------------------------
function PlayFieldPositionFlashedColumn(pn)
	local Style = GAMESTATE:GetCurrentStyle():GetName()
	local Gametype = GAMESTATE:GetCurrentGame():GetName()
	local Pos
	if pn == PLAYER_1 then
		if Gametype == "dance" then
			if Style == "solo" then
				Pos = CenterX()-64
			elseif Style == "single" then
				Pos = CenterX()-228
			elseif Style == "versus" then
				Pos = CenterX()-216
			else
				Pos = CenterX()-128
			end
		end
		if Gametype == "pump" then
			if Style == "single" or Style == "versus" then
				Pos = CenterX()-252
			else
				Pos = 0
			end
		end
		if Gametype == "techno" then
			Pos = CenterX()
		end
	end
	if pn == PLAYER_2 then
		if Gametype == "dance" then
			if Style == "solo" then
				Pos = CenterX()-64
			elseif Style == "single" then
				Pos = CenterX()+228
			elseif Style == "versus" then
				Pos = CenterX()+216
			else
				Pos = CenterX()-128
			end
		end
		if Gametype == "pump" then
			if Style == "single" or Style == "versus" then
				Pos = CenterX()+204
			else
				Pos = 0
			end
		end
		if Gametype == "techno" then
			Pos = CenterX()
		end
	end
	return Pos
end

-------------------------------------------------------------------------------------------------------------------
-- NPS: Enable Notes Per Second during Gameplay.
-------------------------------------------------------------------------------------------------------------------
function IsNPSEnabled(pn)
	local IsEnabled
	local option = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.NPS
	
	if option == "On" then
		IsEnabled = true
	else
		IsEnabled = false
	end
	return IsEnabled
end

-------------------------------------------------------------------------------------------------------------------
-- GraphDisplay: Enable GraphDisplay during Gameplay.
-------------------------------------------------------------------------------------------------------------------
function IsGraphDisplayEnabled(pn)
	local IsEnabled
	local option = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.GraphDisplay
	
	if option == "On" then
		IsEnabled = true
	else
		IsEnabled = false
	end
	return IsEnabled
end

-------------------------------------------------------------------------------------------------------------------
-- RateModUpdateFunction: It will update automatically depending of ratemod value.
-------------------------------------------------------------------------------------------------------------------
function RateModUpdateFunction()
	return MetroQuad.Global.MiscOptions.RateModUsed
end

-------------------------------------------------------------------------------------------------------------------
-- ScoreWeights Functions
-------------------------------------------------------------------------------------------------------------------
function SetScoreWeightsW1() local choose = ThemePrefs.Get("ScoreGradeWeights") local value	if choose == "MQX" then value = 10 else value = 3 end return value end
function SetScoreWeightsW2() local choose = ThemePrefs.Get("ScoreGradeWeights") local value	if choose == "MQX" then value = 9 else value = 2 end return value end
function SetScoreWeightsW3() local choose = ThemePrefs.Get("ScoreGradeWeights") local value	if choose == "MQX" then value = 6 else value = 1 end return value end
function SetScoreWeightsW4() local choose = ThemePrefs.Get("ScoreGradeWeights") local value	if choose == "MQX" then value = 3 else value = 0 end return value end
function SetScoreWeightsW5() local choose = ThemePrefs.Get("ScoreGradeWeights") local value	if choose == "MQX" then value = 0 else value = 0 end return value end
function SetScoreWeightsMiss() local choose = ThemePrefs.Get("ScoreGradeWeights") local value if choose == "MQX" then value = 0 else value = 0 end return value end
function SetScoreWeightsHold() local choose = ThemePrefs.Get("ScoreGradeWeights") local value if choose == "MQX" then value = 3 else value = 3 end return value end

-------------------------------------------------------------------------------------------------------------------
-- GradeWeights Functions 
-------------------------------------------------------------------------------------------------------------------
function SetGradeWeightsW1() local choose = ThemePrefs.Get("ScoreGradeWeights") local value	if choose == "MQX" then value = 10 else value = 2 end return value end
function SetGradeWeightsW2() local choose = ThemePrefs.Get("ScoreGradeWeights") local value	if choose == "MQX" then value = 9 else value = 2 end return value end
function SetGradeWeightsW3() local choose = ThemePrefs.Get("ScoreGradeWeights") local value	if choose == "MQX" then value = 6 else value = 1 end return value end
function SetGradeWeightsW4() local choose = ThemePrefs.Get("ScoreGradeWeights") local value	if choose == "MQX" then value = 3 else value = 0 end return value end
function SetGradeWeightsW5() local choose = ThemePrefs.Get("ScoreGradeWeights") local value	if choose == "MQX" then value = 0 else value = -4 end return value end
function SetGradeWeightsMiss() local choose = ThemePrefs.Get("ScoreGradeWeights") local value	if choose == "MQX" then value = 0 else value = -8 end return value end
function SetGradeWeightsHold() local choose = ThemePrefs.Get("ScoreGradeWeights") local value	if choose == "MQX" then value = 3 else value = 6 end return value end

-------------------------------------------------------------------------------------------------------------------
-- GLOBAL: This will return a different color vale for each Player.
-------------------------------------------------------------------------------------------------------------------
function LifeColorToHex(pn)
	local lcolor = ""
	local option = MetroQuad[ToEnumShortString(pn)].ActiveModifiers.LifeColor
	
	if option == "Normal" then
		lcolor = "#FFFFFF"
	elseif option == "Blue" then
		lcolor = "#0000FF"
	elseif option == "Red" then
		lcolor = "#FF0000"
	elseif option == "Green" then
		lcolor = "#00FF00"
	elseif option == "Yellow" then
		lcolor = "#FFFF00"
	elseif option == "Purple" then
		lcolor = "#FF00FF"
	elseif option == "Orange" then
		lcolor = "#FF7F00"
	elseif option == "Grey" then
		lcolor = "#3e3e3e"
	elseif option == "Teal" then
		lcolor = "#329999"
	end
	return lcolor
end

-------------------------------------------------------------------------------------------------------------------
-- GLOBAL: This will return a number depending of how many Slots has been used.
-------------------------------------------------------------------------------------------------------------------
function NumSlotUsed(pn)
	local SlotsUsed = 0
	local ProfileName = PROFILEMAN:GetProfile(pn)
	
	if PROFILEMAN:GetNumLocalProfiles() == 0 then
		for i = 1,16 do
			local GenericSlot = LoadFile("ThemeSlot"..i..".cfg","Settings/ThemeSlots Generic")
			if GenericSlot ~= "EMPTY" then SlotsUsed = SlotsUsed + 1 end
		end
	else
		for i = 1,16 do
			local ThemeSlot = LoadFile("ThemeSlot"..i..".cfg","Settings/ThemeSlots "..ProfileName:GetDisplayName())
			if ThemeSlot ~= "EMPTY" then SlotsUsed = SlotsUsed + 1 end
		end
	end
	return SlotsUsed
end

-------------------------------------------------------------------------------------------------------------------
-- GLOBAL: This will return a number depending of how many Slots still empty.
-------------------------------------------------------------------------------------------------------------------
function NumSlotLeft(pn)
	local SlotsUsed = 16
	local ProfileName = PROFILEMAN:GetProfile(pn)
	
	if PROFILEMAN:GetNumLocalProfiles() == 0 then
		for i = 1,16 do
			local GenericSlot = LoadFile("ThemeSlot"..i..".cfg","Settings/ThemeSlots Generic")
			if GenericSlot ~= "EMPTY" then SlotsUsed = SlotsUsed - 1 end
		end
	else
		for i = 1,16 do
			local ThemeSlot = LoadFile("ThemeSlot"..i..".cfg","Settings/ThemeSlots "..ProfileName:GetDisplayName())
			if ThemeSlot ~= "EMPTY" then SlotsUsed = SlotsUsed - 1 end
		end
	end
	return SlotsUsed
end

-------------------------------------------------------------------------------------------------------------------
-- For Techno gamemode, "Mission" and "Online" choices will be hidden.
-------------------------------------------------------------------------------------------------------------------
function AvailablesChoicesForGameMode()
	local Game = GAMESTATE:GetCurrentGame():GetName()
	if Game == "techno" then return "Start1Player,Start2Players,GameSelect,Jukebox,Edit,Feature,Options,Root,Exit" end
	if Game ~= "techno" then return "Start1Player,Start2Players,GameSelect,Online,Mission,Jukebox,Edit,Feature,Options,Root,Exit" end
end

-------------------------------------------------------------------------------------------------------------------
-- This will set the style for the choice depending of the gamemode.
-------------------------------------------------------------------------------------------------------------------
function SetStylesOnePlayerForGameMode()
	local Game = GAMESTATE:GetCurrentGame():GetName()
	if Game == "techno" then return "single8" end
	if Game ~= "techno" then return "single" end
end

-------------------------------------------------------------------------------------------------------------------
-- This will set the style for the choice depending of the gamemode.
-------------------------------------------------------------------------------------------------------------------
function SetStylesTwoPlayersForGameMode()
	local Game = GAMESTATE:GetCurrentGame():GetName()
	if Game == "techno" then return "double8" end
	if Game ~= "techno" then return "versus" end
end

-------------------------------------------------------------------------------------------------------------------
-- MISSION MODE: Custom Title
-------------------------------------------------------------------------------------------------------------------
function GetMissionCustomName()
	local mission, cMission
	if GetCurrentCourse() == nil then return nil else mission = GAMESTATE:GetCurrentCourse():GetDisplayFullTitle() end
	
	if mission == "Mission A - 01" then cMission = "Song: Reach Up - Difficulty: 05 / 20"
	elseif mission == "Mission A - 02" then cMission = "Song: Until Forever - Difficulty: 07 / 20"
	elseif mission == "Mission A - 03" then cMission = "Song: Kagami - Difficulty: 05 / 20"
	elseif mission == "Mission A - 04" then cMission = "Song: HOT LIMIT - Difficulty: 08 / 20"
	elseif mission == "Mission A - 05" then cMission = "Song: Freeze - Difficulty: 06 / 20"
	elseif mission == "Mission A - 06" then cMission = "Song: Hyper Hyper - Difficulty: 06 / 20"
	elseif mission == "Mission A - 07" then cMission = "Song: 1, 2, 3, 4, 007 - Difficulty: 08 / 20"
	else cMission = "" end
	
	return cMission
end

-------------------------------------------------------------------------------------------------------------------
-- MISSION MODE: Custom ScreenMission Title
-------------------------------------------------------------------------------------------------------------------
function GetMissionCustomName2()
	local mission, cMission
	if GetCurrentCourse() == nil then return nil else mission = GAMESTATE:GetCurrentCourse():GetDisplayFullTitle() end
	
	if mission == "Mission A - 01" then cMission = "Mission: 01 - Song: Reach Up - Difficulty: 05 / 20"
	elseif mission == "Mission A - 02" then cMission = "Mission: 02 - Song: Until Forever - Difficulty: 07 / 20"
	elseif mission == "Mission A - 03" then cMission = "Mission: 03 - Song: Kagami - Difficulty: 05 / 20"
	elseif mission == "Mission A - 04" then cMission = "Mission: 04 - Song: HOT LIMIT - Difficulty: 08 / 20"
	elseif mission == "Mission A - 05" then cMission = "Mission: 05 - Song: Freeze - Difficulty: 06 / 20"
	elseif mission == "Mission A - 06" then cMission = "Mission: 06 - Song: Hyper Hyper - Difficulty: 06 / 20"
	elseif mission == "Mission A - 07" then cMission = "Mission: 07 - Song: 1, 2, 3, 4, 007 - Difficulty: 08 / 20"
	else cMission = "" end
	
	return cMission
end

-------------------------------------------------------------------------------------------------------------------
-- MISSION MODE:
-------------------------------------------------------------------------------------------------------------------
function GetMissionAreaComplete()
	local mission, Area
	if GetCurrentCourse() == nil then return nil else mission = GAMESTATE:GetCurrentCourse():GetDisplayFullTitle() end
	
	if string.match(mission,"Mission A") then Area = "Novice ()" else Area = "" end
	return "0.00% Completed"
end

-------------------------------------------------------------------------------------------------------------------
-- MISSION MODE: Area
-------------------------------------------------------------------------------------------------------------------
function GetMissionArea()
	local mission, Area
	if GetCurrentCourse() == nil then return nil else mission = GAMESTATE:GetCurrentCourse():GetDisplayFullTitle() end
	
	if string.match(mission,"Mission A") then Area = "Area A" else Area = "" end
	return Area
end

-------------------------------------------------------------------------------------------------------------------
-- MISSION MODE: Area
-------------------------------------------------------------------------------------------------------------------
function GetMissionDesc()
	local mission, desc
	if GetCurrentCourse() == nil then return nil else mission = GAMESTATE:GetCurrentCourse():GetDisplayFullTitle() end
	
	if mission == "Mission A - 01" then desc = "Clear the entire song with less than 15 Misses to pass this mission."
	elseif mission == "Mission A - 02" then desc = "Clear the entire song with no Goods to pass this mission."
	elseif mission == "Mission A - 03" then desc = "During all the song, maintain the Life Meter over the half to pass this mission."
	elseif mission == "Mission A - 04" then desc = "Clear the entire song with less than 25 Greats pressed with the Left Arrow to pass this mission. (Jumps that includes the Left Arrow are counted)."
	elseif mission == "Mission A - 05" then desc = "Get at least 900 or more DP (Dance Points) before the song ends to pass this mission."
	elseif mission == "Mission A - 06" then desc = "Get at least 200 Goods before the song ends to pass this mission."
	elseif mission == "Mission A - 07" then desc = "Get exactly 30 Greats before the song ends to pass this mission."
	else desc = "" end
	return desc
end